{$A+,B-,D+,E-,F-,G-,I+,L+,N-,O-,R+,S+,V-,X-}
PROGRAM Jan_ASseMbler_INput (JASMIN);

CONST
  Ver  : BOOLEAN     = TRUE;
  Regi : STRING [47] = 'AX CX DX BX SP BP SI DI ' +
                       'AL CL DL BL AH CH DH BH';
  SmReg: STRING [11] = 'ES CS SS DS';

  MaxIn= 120;
  Instr: ARRAY [1..MaxIn] OF STRING[6] =
  {  1}  ('MOV','PUSH','POP','IN','OUT','XCHG','LEA','LDS',
  {  9}   'LES','ADD','ADC','SUB','SBB','CMP','AND','TEST',
  { 17}   'OR','XOR','INC','DEC','NEG','AAD','AAM','MUL',
  { 25}   'IMUL','NOT','DIV','IDIV','SHL','SAL','SHR','SAR',
  { 33}   'ROL','ROR','RCL','RCR','CALL','JMP','RET','RETF',
  { 41}   'JE','JZ','JL','JNGE','JLE','JNG','JB','JNAE',
  { 49}   'JBE','JNA','JP','JPE','JO','JS','JNE','JNZ',
  { 57}   'JNL','JGE','JNLE','JG','JNB','JAE','JNBE','JA',
  { 65}   'JNP','JPO','JNO','JNS','LOOP','LOOPZ','LOOPE',
  { 72}   'LOOPNZ','LOOPNE','JCXZ','CLC','CMC','STC','CLD',
  { 79}   'STD','CLI','STI','HLT','WAIT','LOCK','NOP','REP',
  { 87}   'REPZ','REPNZ','REPE','REPNE','MOVSB','CMPSB',
  { 93}   'SCASB','LODSB','STOSB','MOVSW','CMPSW','SCASW',
  { 99}   'LODSW','STOSW','XLAT','LAHF','SAHF','PUSHF',
  {105}   'POPF','AAA','DAA','AAS','DAS','CBW','CWD','INTO',
  {113}   'IRET','INT','DB','DW','CS:','DS:','ES:','SS:');
   RCom: ARRAY [0..11] OF STRING [5] =
         ('BX+SI', 'SI+BX', 'BX+DI', 'DI+BX',
          'BP+SI', 'SI+BP', 'BP+DI', 'DI+BP',
          'SI',    'DI',    'BP',    'BX');
  JDist: ARRAY [1..3] OF STRING [5] =
         ('SHORT', 'NEAR', 'FAR');
  CODE0: ARRAY [ 2.. 5, 1..4] OF BYTE =
         (($50, $06, $FF, $30), ($58, $07, $8F, $00),
          ($00, $00, $EC, $E4), ($00, $00, $EE, $E6));
  CODE1: ARRAY [10..18, 1..4] OF BYTE =
         (($00, $80, $00, $04), ($10, $80, $10, $14),
          ($28, $80, $28, $2C), ($18, $80, $18, $1C),
          ($38, $80, $38, $3C), ($20, $80, $20, $24),
          ($84, $F6, $00, $A8), ($08, $80, $08, $0C),
          ($30, $80, $30, $34));
  CODE2: ARRAY [24..113] OF BYTE =
         ($20,$28,$10,$30,$38,$20,$20,$28,$38,$00,$08,
          $10,$18,$00,$00,$C2,$CA,$74,$74,$7C,$7C,$7E,
          $7E,$72,$72,$76,$76,$7A,$7A,$70,$78,$75,$75,
          $7D,$7D,$7F,$7F,$73,$73,$77,$77,$7B,$7B,$71,
          $79,$E2,$E1,$E1,$E0,$E0,$E3,$F8,$F5,$F9,$FC,
          $FD,$FA,$FB,$F4,$9B,$F0,$90,$F3,$F3,$F2,$F3,
          $F2,$A4,$A6,$AE,$AC,$AA,$A5,$A7,$AF,$AD,$AB,
          $D7,$9F,$9E,$9C,$9D,$37,$27,$3F,$2F,$98,$99,
          $CE,$CF);
  CODE3: ARRAY [37..38, 1..4] OF BYTE =
         (($E8, $9A, $18, $10), ($E9, $EA, $28, $20));

TYPE
  TOpInfo  = RECORD
               oType : (REG, SEGREG, MEM, IMM);
               oText : STRING; oSize :  0..2; oSReg :  0..3;
               oDisp : WORD;   oRM   : -1..7; oMod  : -1..3;
               oIVal : WORD;   oSDisp: BYTE;  oSign : BOOLEAN;
               oLabel: STRING;
             END;
  DataType = ARRAY [0..$FFFE] OF BYTE;

VAR
  CurLineNr, Inst, Nr,
  LastLabel, LastFLabel,
  COM_IP                : WORD;
  MemSize               : LONGINT;
  CurLine, Opd, saveLn,
  INFName, OUTFName,
  ErrMsg, ErrFilename   : STRING;
  ASMInput, INCFile,
  ErrFile               : TEXT;
  Include               : BOOLEAN;
  COMOutput             : FILE OF BYTE;
  COMData               : ^DataType;
  ExitSave              : POINTER;
  Op                    : ARRAY [1..2] OF TOpInfo;
  Lbl                   : ARRAY [1..1000] OF RECORD
                            Addr: WORD;
                            Attr: BYTE;
                            Name: STRING [10]
                          END;
  FLbl                  : ARRAY [1..1000] OF RECORD
                            fAddr, fLine: WORD;
                            fDist: BYTE;
                            fName: STRING[10]
                          END;


FUNCTION UpStr (Strg: STRING): STRING; ASSEMBLER;
ASM
     PUSH   DS
     CLD
     LDS    SI, Strg
     LES    DI, @Result
     LODSB
     STOSB
     XOR    AH, AH
     XCHG   AX, CX
     JCXZ   @3
@1:  LODSB
     CMP    AL, 61h
     JB     @2
     CMP    AL, 7Ah
     JA     @2
     SUB    AL, 20h
@2:  STOSB
     LOOP   @1
@3:  POP    DS
END;

PROCEDURE Val (s: STRING; VAR Value: WORD; VAR ErrCode: BYTE);
VAR v, base: WORD; Err: BYTE;
BEGIN
  base := 0;
  CASE UpCase (s [Length (s)]) OF
    'B': base :=  2;
    'O': base :=  8;
    'D': base := 10;
    'H': base := 16
  END;
  IF base = 0 THEN base := 10
  ELSE Dec (s [0]);
  ASM
       LEA   SI, s
       MOV   BX, base
       XOR   CX, CX
       XOR   DX, DX
       SEGSS LODSB
       XOR   AH, AH
       MOV   DI, AX
       MOV   CL, AL
  @X2: XOR   AH, AH
       SEGSS LODSB
       CMP   AL, 60h
       JB    @X0
       SUB   AL, 20h
  @X0: SUB   AL, 30h
       CMP   AL, 9
       JBE   @X1
       SUB   AL, 7
  @X1: CMP   AX, BX
       JNL   @Err
       CMP   AL, 0
       JL    @Err
       ADD   AX, DX
       CMP   CL, 1
       JE    @Ex
       MUL   BX
       MOV   DX, AX
       LOOP  @X2
  @Ex: MOV   Err, 0
       MOV   v, AX
       JMP   @Exit
  @Err:MOV   AX, DI
       SUB   AL, CL
       INC   AL
       MOV   Err, AL
  @Exit:
  END;
  ErrCode := Err; Value := v
END;

PROCEDURE NewExit; FAR;
BEGIN
  ExitProc := ExitSave;
  {$I-} Close (ASMInput); Close (COMOutput);
  IF ExitCode <> 0 THEN Erase (COMOutput); {$I+}
  IF IOResult <> 0 THEN;
  IF ErrorAddr <> NIL THEN BEGIN
    Assign (ErrFile, ErrFilename);
    {$I-} Reset (ErrFile); {$I+}
    IF IOResult = 0 THEN BEGIN
      REPEAT ReadLn (ErrFile, ErrMsg);
      UNTIL  Eof (ErrFile) OR (Copy (ErrMsg,1,2) =
                               'R' + Chr (ExitCode));
      IF Eof (ErrFile) THEN
        WriteLn ('Runtime Error: ', ExitCode)
      ELSE WriteLn (Copy (ErrMsg, 3, 255)); Close (ErrFile)
    END ELSE WriteLn ('Runtime Error: ', ExitCode);
    ErrorAddr := NIL
  END
END;

PROCEDURE Error (Code: INTEGER);
BEGIN
  IF Code <> 0 THEN BEGIN
    Assign (ErrFile, ErrFilename);
    {$I-} Reset (ErrFile); {$I+}
    IF IOResult = 0 THEN BEGIN
      REPEAT ReadLn (ErrFile, ErrMsg);
      UNTIL  Eof (ErrFile) OR (ErrMsg [1] = Chr (Code));
      IF Eof (ErrFile) THEN ErrMsg := ' unknown error';
      WriteLn (Copy (ErrMsg, 2, 255)); Close (ErrFile);
    END ELSE WriteLn ('Error: ', Code);
    WriteLn (saveLn); Halt
  END
END;

FUNCTION MakeWORD (Strg: STRING): WORD;
VAR ValError: BYTE; B: WORD; S: BOOLEAN;
BEGIN
  IF Strg[1] = '"' THEN BEGIN
    IF (Length (Strg) <> 4)
    OR (Strg[4] <> '"') THEN Error (16);
    MakeWORD := Ord(Strg[2]) OR (WORD (Ord(Strg[3])) SHL 8);
  END ELSE BEGIN
    S := FALSE;
    IF Strg [1] IN ['+', '-'] THEN BEGIN
      S := Strg [1] = '-'; Delete (Strg, 1, 1)
    END;
    Val (Strg, B, ValError);
    IF ValError <> 0 THEN Error (16);
    IF S THEN IF B > 32786 THEN Error (15)
              ELSE MakeWORD := $10000-B
    ELSE MakeWORD := B
  END
END;

FUNCTION MakeBYTE (Strg: STRING): BYTE;
VAR ValError: BYTE; B: WORD; S: BOOLEAN;
BEGIN
  IF Strg[1] = '"' THEN BEGIN
    IF (Length (Strg) <> 3)
    OR (Strg[3] <> '"') THEN Error (16);
    MakeBYTE := Ord (Strg[2]);
  END ELSE BEGIN
    S := FALSE;
    IF Strg [1] IN ['+', '-'] THEN BEGIN
      S := Strg [1] = '-'; Delete (Strg, 1, 1)
    END;
    Val (Strg, B, ValError);
    IF B > 255 THEN Error (14);
    IF ValError <> 0 THEN Error (16);
    IF S THEN IF B > 128 THEN Error (15)
              ELSE MakeBYTE := $100-B
    ELSE MakeBYTE := B
  END
END;

PROCEDURE WriteLineNr;
BEGIN
  {******  entspricht:  GotoXY (1, WhereY)  ******}
  INLINE ($B4/3/$B7/0/$CD/$10/$B4/2/$B2/0/$CD/$10);
  IF Include THEN Write ('[', CurLineNr:4, '] I  ')
             ELSE Write ('[', CurLineNr:4, ']    ')
END;

PROCEDURE FormatLine (Clear: BOOLEAN);
VAR I: BYTE; NoStr: BOOLEAN;
BEGIN
  NoStr := TRUE; I := Pos (';', CurLine);
  IF I <> 0 THEN CurLine [0] := Chr (I-1);
  WHILE (CurLine [1] IN [#9, #32]) AND
    (Length (CurLine) > 0) DO Delete (CurLine, 1, 1);
  WHILE (CurLine [Length (CurLine)] IN [#9, #32]) AND
    (Length (CurLine) > 0) DO Dec (CurLine [0]);
  I := 1;
  WHILE I <= Length (CurLine) DO BEGIN
    IF CurLine [I] = '"' THEN NoStr := NOT NoStr;
    IF NoStr THEN BEGIN
      CurLine [I] := UpCase (CurLine [I]);
      IF Clear AND (CurLine [I] IN [#9, #32]) THEN
        Delete (CurLine,I,1)
      ELSE Inc (I)
    END ELSE Inc (I)
  END
END;

FUNCTION GetInstruction: WORD;
VAR C,L,Nr: BYTE; Strg: STRING;
BEGIN
  Nr := 0; L := 1; GetInstruction := 0;
  IF CurLine = '' THEN Exit;
  IF (Pos (#9,CurLine)<>0) OR (Pos (#32,CurLine)<>0) THEN BEGIN
    WHILE NOT (CurLine [L] IN [#9, #32]) DO Inc (L); Dec (L);
  END ELSE L := Length (CurLine);
  FOR C := 1 TO MaxIn DO
    IF (Copy (CurLine, 1, L)) = Instr [C] THEN Nr := C;
  IF Nr = 0 THEN Error (1); Delete (CurLine, 1, L);
  GetInstruction := Nr
END;

FUNCTION GetLblAddr (Nr: BYTE): WORD;
VAR Cnt: WORD;
BEGIN
  GetLblAddr := 0;
  FOR Cnt := 1 TO LastLabel DO
    IF Lbl[Cnt].Name = Op[Nr].oLabel THEN BEGIN
      GetLblAddr := Lbl[Cnt].Addr; Op[Nr].oLabel := ''
    END
END;

PROCEDURE GetOperand (Nr: BYTE);
VAR cnt, o: BYTE;
BEGIN
  FOR cnt := 1 TO Nr DO BEGIN
    IF CurLine = '' THEN Error (2);
    IF Pos (',', CurLine) <> 0 THEN BEGIN
      Opd := Copy (CurLine, 1, Pos (',',CurLine)-1);
      Delete (CurLine, 1, 1)
    END ELSE Opd := CurLine;
    Delete (CurLine, 1, Length (Opd));
    WITH Op [cnt] DO BEGIN
      oText := Opd; oLabel := ''; oSize := 2;
      IF (Copy (Opd, 1, 7) = 'BYTEPTR') OR
         (Copy (Opd, 1, 7) = 'WORDPTR') THEN BEGIN
          oSize := Ord (Opd [1] = 'W'); Delete (Opd, 1, 7)
      END;
      IF (Pos(Opd,Regi)>0) AND (Length(Opd)=2) THEN BEGIN
        oType:= REG; o := Pos (Opd, Regi) DIV 3;
        oSize:= Ord (o < 8); IF o > 7 THEN Dec (o, 8);
        oRM := o; oMod := 3
      END ELSE IF (Pos (Opd,SmReg)>0) AND (Length (Opd)=2)
      THEN BEGIN
        oType := SEGREG; oSize := 1;
        oSReg := Pos (Opd, SmReg) DIV 3
      END ELSE IF Pos('[',Opd) < Pos(']',Opd) THEN BEGIN
        IF Pos(']',Opd) < Length (Opd) THEN Error (3);
        oType := MEM; Dec (Opd[0]);
        IF (oSize=2) AND (cnt=2) THEN BEGIN
          oSize := Op[1].oSize;
          Error (Ord (oSize = 2)*2);
        END;
        IF Opd[1] <> '[' THEN Error (3)
        ELSE Delete (Opd, 1, 1); oDisp := 0;
        oRM := -1; oMod := 0;
        FOR o := 0 TO 11 DO
          IF Copy (Opd, 1, Length (RCom[o])) = RCom[o] THEN
          BEGIN
            Delete (Opd, 1, Length (RCom [o]));
            IF o > 7 THEN Dec (o, 4) ELSE o := o DIV 2;
            Op [cnt].oRM := o; o := 11;
          END;
        IF (Opd <> '') OR (oRM = -1) THEN BEGIN
          IF Opd[1] = '-' THEN BEGIN
            IF oRM = -1 THEN Error (3);
            oDisp := MakeBYTE (Opd); oMod := 1
          END ELSE BEGIN
            IF Opd[1] = '+' THEN Delete (Opd, 1, 1);
            IF (Copy (Opd, 1, 6) = 'OFFSET') OR
            (Opd [1] = '?') THEN BEGIN
              oIVal := 0;
              IF Opd [1] = '?' THEN Delete (Opd, 1, 1)
              ELSE Delete (Opd, 1, 6);
              IF Pos ('+', Opd) <> 0 THEN BEGIN
                oIVal := MakeWORD (Copy (Opd,
                  Pos ('+',Opd)+1, 255));
                Delete (Opd, Pos ('+', Opd), 255);
              END; oLabel := Opd;
              oDisp := GetLblAddr (Cnt);
              Inc (oDisp, oIVal+$100);
            END ELSE oDisp := MakeWORD (Opd);
            IF oRM = -1 THEN oRM := 6
            ELSE IF oLabel <> '' THEN oMod := 2
            ELSE oMod := Ord (oDisp > 127)+1
          END
        END ELSE IF oRM = 6 THEN oMod := 1;
        IF oRM = -1 THEN Error (3);
      END ELSE IF (Copy (Opd, 1, 6) = 'OFFSET')
      OR (Opd [1] = '?') THEN BEGIN
        oType := IMM; oIVal := 0; oSize := 1; oDisp := $100;
        IF Opd [1] = '?' THEN Delete (Opd, 1, 1)
        ELSE Delete (Opd, 1, 6); oLabel := Opd;
        IF Pos ('+', Opd) <> 0 THEN BEGIN
          Delete (Opd, 1, Pos ('+', Opd));
          Inc (oDisp, MakeWORD (Opd));
          Delete (oLabel, Pos ('+', oLabel), 255)
        END; oIVal := GetLblAddr (Cnt)
      END ELSE BEGIN
        oType := IMM; oDisp := 0; oSign := FALSE;
        IF (oSize=2) AND (cnt=2) THEN BEGIN
          oSize := Op[1].oSize;
          Error (Ord (oSize = 2)*2);
        END;
        IF (oSize = 2) AND (Nr = 1) THEN BEGIN
          oIVal := MakeWORD (Opd);
          oSize := Ord (oIVal > $FF)
        END ELSE
        IF oSize = 0 THEN oIVal := MakeBYTE (Opd)
        ELSE oIVal := MakeWORD (Opd)
      END
    END
  END;
  IF (Op [1].oSize = 2) AND (Nr = 2) THEN
    Op [1].oSize := Op [2].oSize;
  IF (Op [1].oSize = 2) OR (CurLine <> '') OR (Ver
  AND ((Op [1].oSize <> Op [2].oSize) AND (Nr = 2)))
  THEN Error (2)
END;

PROCEDURE Push (Value: BYTE);
BEGIN
  IF COM_IP >= MemSize THEN Error (9);
  COMData^ [COM_IP] := Value; Inc (COM_IP)
END;

PROCEDURE PushFLbl (Nr, Dist: BYTE; Wd: WORD);
BEGIN
  IF Op[Nr].oLabel <> '' THEN BEGIN
    Inc (LastFLabel);
    WITH FLbl [LastFLabel] DO BEGIN
      fName := Op[Nr].oLabel; fLine := CurLineNr;
      fAddr := COM_IP; fDist := Dist
    END
  END; Push (Lo (Wd));
  IF Dist > 1 THEN Push (Hi (Wd))
END;

PROCEDURE PushDisp (Nr: BYTE);
BEGIN
  IF Op [Nr].oType <> MEM THEN Exit;
  WITH Op [Nr] DO CASE oMod OF
    0: IF oRM = 6 THEN
         PushFLbl (Nr, $FE, oDisp);
    1: Push (Lo (oDisp));
    2: PushFLbl (Nr, $FE, oDisp)
  END
END;

PROCEDURE Assemble;
VAR
  OpHelp : TOpInfo;
  LStrg  : STRING;
  Test, J: WORD;
  TestI,
  ValErr : INTEGER;
  ByteVar: BYTE;
  CharB  : CHAR;
BEGIN
  IF CurLine = '' THEN Exit;
  IF CurLine [1] = '@' THEN BEGIN
    IF Pos (':', CurLine) = 0 THEN Error (1);
    LStrg := CurLine; LStrg[0] := Chr (Pos(':',CurLine)-1);
    FOR Test := 1 TO LastLabel DO
      IF Lbl[Test].Name = LStrg THEN Error (4);
    Inc (LastLabel); Lbl [LastLabel].Name := LStrg;
    Lbl [LastLabel].Addr := COM_IP;
    Delete (CurLine, 1, Pos (':', CurLine))
  END;
  FormatLine (FALSE);
  Inst := GetInstruction;
  FormatLine (TRUE);
  CASE Inst OF
    0:;
    1: WITH Op[1] DO BEGIN   {---MOV}
         GetOperand (2);
         CASE oType OF
           REG: CASE Op[2].oType OF
                  REG: IF oSize=Op[2].oSize THEN BEGIN
                         Push ($88 OR oSize); Push ($C0
                         OR Op[2].oRM SHL 3 OR oRM)
                       END ELSE Error (2);
                  MEM: BEGIN
                         Push ($8A OR oSize); Push (
                         Op[2].oMod SHL 6 OR oRM SHL 3
                         OR Op[2].oRM); PushDisp (2)
                       END;
                  IMM: IF oSize>=Op[2].oSize THEN BEGIN
                         Push ($B0 OR oSize SHL 3 OR oRM);
                         WITH Op[2] DO IF oLabel <> '' THEN
                           IF oIVal = 0 THEN BEGIN
                             PushFLbl (2, $FE, oDisp);
                             Exit
                           END;
                         Inc (Op[2].oIVal, Op[2].oDisp);
                         Push (Lo (Op[2].oIVal));
                         IF oSize = 1 THEN
                           Push (Hi (Op[2].oIVal))
                       END ELSE Error (2);
                  SEGREG: IF oSize = 1 THEN BEGIN
                         Push ($8C); Push ($C0 OR
                         Op[2].oSReg SHL 3 OR oRM)
                       END ELSE Error (2)
                  ELSE Error (2)
                END;
           MEM: CASE Op[2].oType OF
                  REG: BEGIN
                         Push ($88 OR Op[2].oSize);
                         Push (oMod SHL 6 OR Op[2].oRM SHL 3
                         OR oRM); PushDisp (1)
                       END;
                  IMM: IF oSize >= Op[2].oSize THEN BEGIN
                         Push ($C6 OR oSize); Push (oMod
                         SHL 6 OR oRM); PushDisp (1);
                         WITH Op[2] DO IF oLabel <> '' THEN
                           IF oIVal = 0 THEN BEGIN
                             PushFLbl (2, $FE, oDisp); Exit
                           END;
                         Inc (Op[2].oIVal, Op[2].oDisp);
                         Push (Lo (Op[2].oIVal));
                         IF oSize = 1 THEN
                           Push (Hi (Op[2].oIVal))
                       END ELSE Error (2);
                  SEGREG: BEGIN
                         Push ($8C); Push (oMod SHL 6 OR
                         Op[2].oSReg SHL 3 OR oRM);
                         PushDisp (1)
                       END
                  ELSE Error (2)
                END;
           SEGREG: BEGIN
                  IF NOT (Op[2].oType IN [REG, MEM]) THEN
                    Error (17);
                  Push ($8E); Push (Op[2].oMod SHL 6 OR
                  oSReg SHL 3 OR Op[2].oRM);
                  PushDisp (2)
                END;
           ELSE Error (2)
         END
       END;
    2..                      {--PUSH..---POP}
    3: BEGIN
         GetOperand (1);
         WITH Op[1] DO CASE oType OF
           REG: Push (CODE0 [Inst, 1] OR oRM);
           SEGREG: Push (CODE0 [Inst, 2] OR oSReg SHL 3);
           MEM: BEGIN
                  Push (CODE0 [Inst, 3]);
                  Push (CODE0 [Inst, 4] OR oMod SHL 6
                   OR oRM); PushDisp (1)
                END;
           ELSE Error (2)
         END
       END;
    4..                      {----IN..---OUT}
    5: BEGIN
         Ver := FALSE; GetOperand (2); Ver := TRUE;
         WITH Op[Inst-3] DO
           IF (oText<>'AX') AND (oText<>'AL') THEN Error(2);
         IF Op[Ord (NOT Odd (Inst))+1].oText = 'DX' THEN
           Push (CODE0 [Inst, 3] OR Op[Inst-3].oSize)
         ELSE WITH Op[Ord (NOT Odd (Inst))+1] DO
           IF oType = IMM THEN BEGIN
             IF oSize <> 0 THEN Error (2);
             Push (CODE0 [Inst, 4] OR Op[Inst-3].oSize);
             Push (Lo (oIVal))
           END ELSE Error (2)
       END;
    6: BEGIN                 {--XCHG}
         GetOperand (2);
         IF (Op[1].oType = REG) AND
            (Op[2].oType = MEM) THEN BEGIN
           OpHelp := Op[1]; Op[1] := Op[2]; Op[2] := OpHelp
         END;
         IF Op[2].oType <> REG THEN Error (2);
         WITH Op[1] DO CASE oType OF
           REG   : BEGIN
                     IF oSize<>Op[2].oSize THEN Error (2);
                     IF Op[2].oText = 'AX' THEN
                       Push ($90 OR oRM)
                     ELSE BEGIN
                       Push ($86 OR Op[2].oSize);
                       Push ($C0 OR oRM SHL 3
                       OR Op[2].oRM)
                     END
                   END;
           MEM   : BEGIN
                     Push ($86 OR Op[2].oSize);
                     Push (oMod SHL 6 OR Op[2].oRM SHL 3
                     OR oRM); PushDisp (1)
                   END;
           ELSE    Error (2)
         END
       END;
    7: WITH Op[2] DO BEGIN   {---LEA}
         GetOperand (2);
         IF NOT ((Op[1].oType=REG) AND (Op[1].oSize=1)
          AND (oType=MEM) AND (oSize=1)) THEN Error (2);
         Push ($8D); Push (oMod SHL 6 OR Op[1].oRM SHL 3
          OR oRM); PushDisp (2)
       END;
   10..                      {---ADD..---XOR}
   18: BEGIN
         GetOperand (2);
         IF Op[2].oType = IMM THEN WITH Op[2] DO BEGIN
           IF NOT (Op[1].oType IN [REG, MEM]) OR (Op[1].
            oSize < oSize) OR (oSign AND (Inst>14)) THEN
            Error (2);
           Push (CODE1 [Inst, 2] OR Ord (oSign) SHL 1
            OR Op[1].oSize);
           Push (Op[1].oMod SHL 6 OR CODE1 [Inst, 3]
           OR Op[1].oRM); PushDisp (1); Push (Lo (oIVal));
           IF (Inst > 14) THEN IF Op[1].oSize = 1 THEN
             Push (Hi (oIVal))
           ELSE ELSE IF NOT oSign AND (Op[1].oSize = 1) THEN
             Push (Hi (oIVal))
         END ELSE
         WITH Op[1] DO CASE oType OF
           REG: BEGIN
                  IF Op[2].oType IN [REG, MEM] THEN BEGIN
                    IF (Op[2].oType = REG) AND (oSize <>
                     Op[2].oSize) THEN Error (2);
                    Push (CODE1 [Inst,1]
                     OR 2 OR oSize);
                    Push (Op[2].oMod SHL 6 OR oRM SHL 3
		     OR Op[2].oRM); PushDisp (2)
                  END ELSE Error (2)
                END;
           MEM: BEGIN
                  IF Op[2].oType <> REG THEN Error (2);
                  Push (CODE1 [Inst,1]
                   OR Op[2].oSize);
                  Push (oMod SHL 6 OR Op[2].oRM SHL 3
                   OR oRM); PushDisp (1)
                END;
           ELSE Error (2)
         END
       END;
   19..                      {---INC..---DEC}
   20: WITH Op[1] DO BEGIN
         GetOperand (1); ByteVar := 0;
         IF Inst = 20 THEN ByteVar := 8;
         IF NOT (oType IN [REG, MEM]) THEN Error (2);
         IF (oType = REG) AND (oSize = 1) THEN
           Push (($40 + ByteVar) OR oRM)
         ELSE BEGIN
           Push ($FE OR oSize);
           Push (oMod SHL 6 OR ByteVar OR oRM); PushDisp (1)
         END
       END;
   21: BEGIN                 {---NEG}
         GetOperand (1);
         WITH Op[1] DO BEGIN
           IF NOT (oType IN [REG, MEM]) THEN Error (2);
           Push ($F6 OR oSize);
           Push (oMod SHL 6 OR $18 OR oRM); PushDisp (1)
         END
       END;
   22: BEGIN                 {---AAD}
         GetOperand (0);
         Push ($D5); Push ($0A)
       END;
   23: BEGIN                 {---AAM}
         GetOperand (0);
         Push ($D4); Push ($0A)
       END;
   24..                      {---MUL..--IDIV}
   28: WITH Op[1] DO BEGIN
         GetOperand (1); Push ($F6 OR oSize);
         Push (oMod SHL 6 OR CODE2 [Inst] OR oRM);
	 PushDisp (1)
       END;
   29..                      {---SHL..---RCR}
   36: WITH Op[2] DO BEGIN
         Ver := FALSE; GetOperand (2); Ver := TRUE;
         IF NOT (((oType = REG) AND (oText = 'CL'))
         OR ((oType = IMM) AND (oIVal = 1))) THEN Error (2);
         Push ($D0 OR Ord(oText='CL') SHL 1 OR Op[1].oSize);
         Push (Op[1].oMod SHL 6 OR  CODE2 [Inst]
         OR Op[1].oRM); PushDisp (1)
       END;
   37..                      {--CALL..---JMP}
   38: WITH Op[1] DO BEGIN   
         J := 1;
         WHILE (J <= 3) AND NOT (Copy (CurLine, 1, Length (
         JDist [J])) = JDist [J]) DO Inc (J);
         IF J < 4 THEN Delete (CurLine,1,Length(JDist[J]));
         IF ((J > 2) AND (Pos(':',CurLine) <> 0)) THEN BEGIN
           Push(CODE3 [Inst, 2]);
           Test := Pos (':', CurLine);
           J := MakeWORD (Copy (CurLine, 1, Test-1));
           Delete (CurLine, 1, Test);
           Test := MakeWORD (CurLine);
           Push (Lo (Test)); Push (Hi (Test));
           Push (Lo (J)); Push (Hi (J)); Exit
         END;
         IF CurLine[1] <> '@' THEN BEGIN
           GetOperand (1); WITH Op[1] DO BEGIN
             IF NOT (oType IN [MEM, REG]) THEN Error (2);
             IF J <> 3 THEN J := 4; Push ($FF);
             ByteVar := CODE3 [Inst, J];
             Push (oMod SHL 6 OR ByteVar OR oRM);
             PushDisp (1)
           END; Exit
         END;
         Op[1].oLabel := CurLine;
         IF (Inst = 37) AND (J = 1) THEN J := 2;
         IF J = 1 THEN Push ($EB)
         ELSE Push (CODE3 [Inst, 1]);
         Test := GetLblAddr (1);
         IF Op[1].oLabel = '' THEN BEGIN
           IF J = 1 THEN BEGIN
             IF COM_IP-Test > 126 THEN Error (5);
             Push ($FF-(COM_IP-Test)); Exit
           END;
           J := $FFFF- (COM_IP - Test) - 1;
           Push (Lo (J)); Push (Hi (J))
         END ELSE PushFLbl (1, J, 0)
       END;
   39..                      {---RET..---RETF}
   40: BEGIN
         IF CurLine = '' THEN Push (CODE2 [Inst] OR 1)
         ELSE WITH Op[1] DO BEGIN
           GetOperand (1); Push (CODE2 [Inst]);
           IF NOT ((oType=IMM) AND NOT (oLabel <> '')) THEN
             Error(2);
           Push (Lo (oIVal)); Push (Hi (oIVal))
         END
       END;
   41..                      {----JE..--JCXZ}
   74: BEGIN
         IF CurLine[1] = '$' THEN BEGIN
           Delete (CurLine, 1, 1);
           Push (CODE2 [Inst]);
           Push (MakeByte(CurLine));
         END ELSE BEGIN
           IF CurLine[1] <> '@' THEN Error (1);
           Push (CODE2 [Inst]); Op[1].oLabel := CurLine;
           Test := GetLblAddr (1);
           IF Op[1].oLabel = '' THEN BEGIN
             IF COM_IP-Test > 126 THEN Error (5);
             Push ($FF-(COM_IP-Test)); Exit
           END; PushFLbl (1, 1, 0);
           IF Inst IN [69..73] THEN Error (6)
         END;
       END;
   75..                      {---CLC..--IRET}
  113: BEGIN
         GetOperand (0);
         Push (CODE2 [Inst])
       END;
  114: WITH Op[1] DO BEGIN   {---INT}
         GetOperand (1);
         IF (oType = IMM) AND (oSize = 0) THEN
           IF oIVal = 3 THEN Push ($CC)
           ELSE BEGIN Push ($CD); Push (Lo (oIVal)) END
         ELSE Error (2)
       END;
  115: BEGIN                 {----DB}
         IF CurLine = '' THEN Push (0)
         ELSE WHILE CurLine <> '' DO BEGIN
           WHILE (CurLine[1]='"') AND (CurLine<>'') DO BEGIN
             Delete (CurLine, 1, 1);
             IF Pos ('"', CurLine) = 0 THEN Error (7);
             WHILE CurLine[1] <> '"' DO BEGIN
               Push (Ord (CurLine[1]));
	       Delete (CurLine, 1, 1)
             END; Delete (CurLine, 1, 1);
             IF (CurLine <> '') AND (CurLine[1] <> ',') THEN
               Error (8); Delete (CurLine, 1, 1)
           END; IF CurLine = '' THEN Exit;
           Test := Pos (',', CurLine);
           IF Test <> 0 THEN BEGIN
             LStrg := Copy (CurLine, 1, Test-1);
             Delete (CurLine, 1, Test)
           END ELSE BEGIN
	     LStrg := CurLine; CurLine := ''
	   END;
           ByteVar := MakeBYTE (LStrg); Push (ByteVar)
         END
       END;
  116: BEGIN                 {----DW}
         IF CurLine = '' THEN BEGIN
           Push (0); Push (0)
         END ELSE WHILE CurLine <> '' DO BEGIN
           Test := Pos (',', CurLine);
           IF Test <> 0 THEN BEGIN
             LStrg := Copy (CurLine, 1, Test-1);
             Delete (CurLine, 1, Test)
           END ELSE BEGIN
	     LStrg := CurLine; CurLine := ''
	   END;
           Test := MakeWORD (LStrg);
           Push (Lo (Test)); Push (Hi (Test))
         END
       END;
  117: Push ($2E); {---CS:}
  118: Push ($3E); {---DS:}
  119: Push ($26); {---ES:}
  120: Push ($36); {---SS:}
  END
END;

PROCEDURE Pass2;
VAR
  w1, w2, Disp: WORD;
  LblOk       : BOOLEAN;
BEGIN
  FOR w1 := 1 TO LastFLabel DO BEGIN
    LblOk := FALSE; CurLineNr := FLbl[w1].fLine;
    WriteLineNr;
    FOR w2 := 1 TO LastLabel DO
      WITH FLbl [w1], Lbl [w2] DO
        IF Name = fName THEN BEGIN
          LblOk := TRUE;
          IF fDist = 1 THEN BEGIN
            IF Addr-fAddr > 129 THEN Error (5);
	    Inc (COMData^[fAddr], Addr-fAddr-1)
          END ELSE BEGIN
            Disp := Addr-fAddr-2;
	    IF fDist = $FE THEN Disp := Addr;
            Inc (COMData^[fAddr], Lo (Disp));
            Inc (COMData^[fAddr+1], Hi (Disp))
          END
        END;
    CurLineNr := FLbl [w1].fLine;
    IF NOT LblOk THEN BEGIN
      saveLn := 'can not locate '+FLbl [w1].fName;
      Error (6)
    END;
  END
END;

BEGIN
  ErrFilename := 'JASMIN.ERR';
  LastLabel := 0; LastFLabel := 0;
  COM_IP := 0; CurLineNr := 1;
  MemSize := MaxAvail;
  IF MemSize > $FFFF THEN MemSize := $FFFF;
  GetMem (ComData, MemSize);
  ExitSave := ExitProc; ExitProc := @NewExit;
  WriteLn (#13#10'JASMIN    --- Freeware ---   Version 1.6');
  WriteLn ('8088/86 Jan laitenberger ASseMbler INput');
  WriteLn ('max. size of COM file: ',MemSize:11,' bytes');
  OUTFName := '';
  CASE ParamCount OF
    0: BEGIN
         Write ('source [.JAS]: '); ReadLn (INFName);
         Write ('target [.COM]: '); ReadLn (OUTFName)
       END;
    1: INFName := ParamStr (1);
    ELSE BEGIN
      INFName := ParamStr (1); OUTFName := ParamStr (2)
    END
  END;
  INFName := UpStr (INFName); OUTFName := UpStr (OUTFName);
  IF Pos ('.', INFName) = 0 THEN INFName := INFName+'.JAS';
  IF OUTFName = '' THEN
    OUTFName := Copy (INFName, 1, Pos ('.', INFName)-1);
  IF Pos ('.', OUTFName)= 0 THEN OUTFName := OUTFName + '.COM';
  Assign (ASMInput, INFName); Assign (COMOutput, OUTFName);
  WriteLn; Reset (ASMInput); Rewrite (COMOutput);
  Include := FALSE; WriteLineNr;
  WHILE NOT Eof (ASMInput) DO BEGIN
    ReadLn (ASMInput, CurLine);
    saveLn := CurLine; FormatLine (FALSE);
    IF Copy (CurLine, 1, 7) = 'INCLUDE' THEN BEGIN
      Delete (CurLine, 1, 7); FormatLine (FALSE);
      Assign (INCFile, CurLine); Reset (INCFile);
      Include := TRUE; Inc (CurLineNr); WriteLineNr;
      WHILE NOT Eof (INCFile) DO BEGIN
        ReadLn (INCFile, CurLine); saveLn := CurLine;
        FormatLine (FALSE); Assemble; Inc (CurLineNr);
        WriteLineNr;
      END; Close (INCFile); Include := FALSE;
      WriteLineNr
    END ELSE BEGIN
      Assemble; Inc (CurLineNr); WriteLineNr
    END
  END;
  Dec (CurLineNr); WriteLineNr;
  Inst := CurLineNr;  Pass2;
  CurLineNr := Inst;  WriteLineNr;
  IF COM_IP > 0 THEN
    FOR Inst := 0 TO COM_IP-1 DO
      Write (COMOutput, COMData^[Inst]);
  Close (COMOutput);
  WriteLn ('Ready, ',COM_IP,' bytes written.')
END.