PROGRAM MakeBootSector;

VAR
  Sector: ARRAY [0..511] OF BYTE;
  BFile : FILE;

FUNCTION SecIO (IO, xDrive, xSide, xTrack, S: BYTE;
                SEGM, OFFS: WORD): BYTE;
BEGIN
  ASM
    PUSH ES         ;  MOV DI, 4
    @Repeat: DEC DI ;  CMP DI, 0
    JE @Exit        ;  MOV AH, 3
    CMP IO, 0       ;  JNE @Wr
    MOV AH, 2       ;  @Wr: MOV DL, xDrive
    MOV DH, xSide   ;  MOV CH, xTrack
    MOV CL, S       ;  MOV BX, SEGM
    MOV ES, BX      ;  MOV BX, OFFS
    MOV AL, 1       ;  INT 13h
    CMP AH, 0       ;  JNE @Repeat
    @Exit:
    MOV @Result,AH  ;  POP ES
  END
END;

VAR
  Drive: BYTE;
  Param: STRING [10];

BEGIN
  WriteLn ('BootMaker v1.02B (c) 1991 by Jan Laitenberger');
  IF ParamCount < 2 THEN BEGIN
    WriteLn ('This program requires two parameters:');
    WriteLn ('BOOTMAKE  d:  <filename>'); WriteLn;
    WriteLn ('d          is specifying the diskdrive and');
    WriteLn ('<filename> a program smaller then 450 Bytes');
    WriteLn ('           DO NOT USE INT 21 - CALLS !!!');
    Exit
  END;
  Param := ParamStr (1);
  IF (Length (Param) <> 2) OR (Param[2] <> ':') THEN
  BEGIN WriteLn ('Invalid drive'); Exit END;
  Drive := Ord (UpCase (Param[1])) - 65;
  IF SecIO (0, Drive, 0, 0, 1, Seg (Sector), Ofs (Sector))
  <> 0 THEN BEGIN
    WriteLn ('Not able to read bootsector'); Exit
  END; FillChar (Sector [54], 458, 0);
  Sector[0] := $EB; Sector[1] := $34; Sector[2] := $90;
  Assign (BFile, ParamStr (2));
  {$I-} Reset (BFile, 1); {$I+}
  IF IOResult <> 0 THEN WriteLn ('File not found')
  ELSE BEGIN
    IF FileSize (BFile) > 450 THEN BEGIN
      WriteLn ('File is too big for a bootsector'); Exit
    END; BlockRead (BFile, Sector [54], FileSize (BFile));
    IF SecIO (1, Drive, 0, 0, 1,
              Seg (Sector), Ofs (Sector)) <> 0 THEN BEGIN
      WriteLn ('Not able to write bootsector')
    END; WriteLn ('New bootsector installed');
    Close (BFile)
  END;
END.